up:: [[Habit formation provides an evolutionary advantage]]
tags:: #source/paper #on/willpower
dates:: 2010
people:: Michael D. Robinson, Brandon J. Schmeichel, Michael Inzlicht
URL:: [paper](https://onlinelibrary.wiley.com/doi/abs/10.1111/j.1751-9004.2009.00244.x)

#### A Cognitive Control Perspective of Self-Control Strength and Its Depletion - Robinson, Et al. 2010
*Abstract*: Self‐control strength is a central construct to theories of willpower, optimal functioning, freedom from addiction, and abilities to override problematic social motives and behaviors (e.g., aggression). Understanding the processing basis of self‐control strength, and more particularly its depletion, is thus of paramount importance to both basic and applied literatures. Self‐control strength, the present review suggests, can be profitably viewed in cognitive control terms, particularly so in relation to operations of a brain‐based cognitive control circuit involving the anterior cingulate cortex (linked to monitoring potential or actual unwanted outcomes) and the dorsolateral prefrontal cortex (linked to controlling potential or actual unwanted outcomes). Also, sufficient task motivation is important to operations of this circuit and depletion effects might be understood in terms of such depletion effects on task motivation. Multiple sources of evidence are marshaled in support of this cognitive control perspective of self‐control strength. It is concluded that viewing self‐control strength in cognitive control terms has considerable merit. Social, cognitive, personality, and clinical sources of data are integrated in the analysis.
	- why: 

#### Extracted Annotations (3/7/2015, 4:26:55 PM)

"William James (1890) was among the first psychologists to highlight the importance of self-control to adaptive functioning." (Robinson et al 2010:189)

"The self-control and cognitive control literatures, thus, would seem to overlap considerably in their mutual concern with the person's ability to inhibit dominant responses in a task-defined or otherwise strategic manner (Miller & Cohen, 2001; van Veen & Carter, 2006)." (Robinson et al 2010:191)

"In neurocognitive terms, the anterior cingulate cortex (ACC) is involved in monitoring problematic processing and behavioral occurrences (van Veen & Carter, 2006), whereas the dorsolateral prefrontal cortex (dlPFC) is involved in instantiating cognitive control in a goal-directed (rather than habitual) manner (Kerns et al., 2004; Lieberman & Eisenberger, 2005)." (Robinson et al 2010:191)

"we suggest that self-control is probably not special, but rather borrows from a general-purpose brain-based system related to concern with, monitoring of, and remediation of problematic events and behaviors of multiple types (Miller & Cohen, 2001)." (Robinson et al 2010:192)

"An energizer of the cognitive control system is motivation (Sarter, Gehring, & Kozak, 2006). Stated in other terms, if there is low motivation to control a problematic tendency, it is unlikely that the cognitive control system of the prefrontal cortex will be recruited. This in turn would result in suboptimal performance (Lieberman & Eisenberger, 2005). Thus, one major component to self-control strength is likely one's willingness to work hard on a difficult task." (Robinson et al 2010:192)

"Potentially separable from self-control capacity or even task motivation is what we term task monitoring. To perform non-habitual tasks well, potential or actual mistakes must be recognized. In the absence of recognizing error-proneness, cognitive and behavioral habits would dominate (Lieberman & Eisenberger, 2005)" (Robinson et al 2010:192)

"Although many of these habits would generally serve the self, many would not (Bargh & Chartrand, 1999)." (Robinson et al 2010:192) ^309fcc

"The success (versus failure) of cognitive control is primarily a result of dlPFC activation (Kerns et al., 2004) and the processes uniquely implemented by this brain structure (Knight & Stuss, 2002)." (Robinson et al 2010:192)

"Note that these consequences of dlPFC damage are highly consistent with impaired self-control as highlighted by the strength-based theory of self-control (Baumeister et al., 2000). Thus, it is suggested that the recruitment of the dlPFC's resources should play an important role in understanding whether self-control will be instantiated or not (Goldberg, 2001)." (Robinson et al 2010:192)

"These data strongly suggest that basic processes related to cognitive control (e.g., working memory, reliant on the dlPFC: Goldberg, 2001) overlap considerably with those involved in self-control of a more molar social type (e.g., suppressing one's emotional displays)." (Robinson et al 2010:193)

"In sum, there appears to be a close potential link between lower levels of task-motivation and self-control failures." (Robinson et al 2010:193)

"The latter result is particularly important because numerous studies have now shown that being mindful of present reality (i.e., monitoring it to a greater extent) mitigates even clinical tendencies toward depression (Williams, 2008)." (Robinson et al 2010:193)

"Compton et al. (2008) found that individuals displaying stronger ERN responses to errors (reflecting error-monitoring processes: Holroyd & Coles, 2002) were better able to control their emotional reactions to stressors in daily life." (Robinson et al 2010:193)

"ERN" (Robinson et al 2010:193)

"ndividuals displaying stronger ERNs had higher GPAs, a classic measure of self-control success (Tangney, Baumeister, & Boone, 2004)." (Robinson et al 2010:193)

"the monitoring processes linked to the ACC (" (Robinson et al 2010:193)

"ERN" (Robinson et al 2010:193)

"They found that a self-control depletion manipulation resulted in a smaller subsequent ERN signal in a basic cognitive task. Conceptually similar results have been reported by others (Inzlicht, McKay, & Aronson, 2006; Richeson & Shelton, 2003)." (Robinson et al 2010:194)

"Thus, task monitoring is sensitive to both depletion and motivational influences and may thus be a key component of whether self-control performance will be successful or not." (Robinson et al 2010:194)

"ACC serves a quite general purpose in recognizing problematic occurrences, cognitive as well as social" (Robinson et al 2010:194)

"Finally, there is a great deal of convergence on the importance of the ACC (the generator of the ERN: van Veen & Carter, 2002) to monitoring both unwanted cognitive and social outcomes. It is well-established that the ACC responds to error-prone contexts or actual errors (van Veen & Carter, 2006). More recently, it has been shown that the ACC responds to social rejection manipulations (Eisenberger, Lieberman, & Williams, 2003), pain (Rainville, Duncan, Price, Carrier, & Bushnell, 1997), and negative emotional events and experiences (Duncan & Barrett, 2007). Data of this type have led to the idea that the ACC serves a quite general purpose in recognizing problematic occurrences, cognitive as well as social (Lieberman & Eisenberger, 2005). Results of this type are further suggestive that the same ACC-dlPFC circuit is likely to be involved in both cognitive control and self-control (Goldberg, 2001)." (Robinson et al 2010:194)

"role of the ACC is conceptualized as a problem-monitor" (Robinson et al 2010:194)

"Thus, the role of the ACC is conceptualized as a problem-monitor, which in turn recruits the dlPFC to do the actual work of inhibiting problematic response tendencies (Miller & Cohen, 2001)." (Robinson et al 2010:194)

"The first source establishes quite clearly that damage to the dlPFC results in problems in controlling habitual thoughts, feelings, motivations, and behaviors (Knight & Stuss, 2002)." (Robinson et al 2010:194)

"Thus, if there is a brain locus of self-control, it is most clearly dependent on processes instantiated by the dlPFC (Goldberg, 2001)." (Robinson et al 2010:194)

"In this cognitive control context, the five studies of Robinson (2007) are informative. He found that individuals who paused following their cognitive errors to a greater extent reported (1) higher levels of life satisfaction, (2) lower levels of depression, (3) were seen to be happier by naı ̈ve observers, (4) were better capable of recognizing rewards and punishments in the environment, and (5) exhibited better abilities to inhibit dominant task sets." (Robinson et al 2010:194)

"Moeller and Robinson (2009) found that men, relative to women, exhibited this tendency to a lesser extent, consistent with men's greater levels of behavioral impulsivity (e.g., Eagly & Steffen, 1986)." (Robinson et al 2010:195)

"Thus, a cognitive control model of self-control strength appears to have considerable value," (Robinson et al 2010:195)

"ACC to serve as an effective 'alarm' system" (Robinson et al 2010:195)

"For the ACC to serve as an effective 'alarm' system (Lieberman & Eisenberger, 2005), it should remain quiescent much of the time. Otherwise, it would lose its value, much like in the 'boy who cried wolf' parable." (Robinson et al 2010:195)

"What Baumeister and Vohs additionally suggested was that people are motivated to preserve their self-control resources for possible future use. Thus, there may be an inverse relation between task motivation and motivation to preserve one's self-control resources." (Robinson et al 2010:196)

"A further question should be considered - namely, whether self-control strength can be viewed in motivational rather than capacity-related terms, a possibility hinted at by some sources of data (Moller et al., 2006; Muraven & Slessareva, 2003). Regardless, further work concerned with this motivational-capacity interface seems desirable in better understanding it." (Robinson et al 2010:197)

---

- Back Matter
	- published:: 2010
	- read:: 2015-03-07

---